/*
 * Decompiled with CFR 0.152.
 */
package xyz.derkades.serverselectorx.placeholders;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import org.bukkit.configuration.file.FileConfiguration;
import xyz.derkades.serverselectorx.Main;
import xyz.derkades.serverselectorx.lib.gson.JsonObject;
import xyz.derkades.serverselectorx.lib.gson.JsonSerializer;
import xyz.derkades.serverselectorx.placeholders.GlobalPlaceholder;
import xyz.derkades.serverselectorx.placeholders.Placeholder;

public class Server {
    private static final JsonObject EMPTY_OBJECT = new JsonObject();
    public static final JsonSerializer<Server> SERIALIZER = (src, typeOfSrc, context) -> {
        JsonObject json = new JsonObject();
        json.addProperty("name", src.getName());
        json.addProperty("online", src.isOnline());
        if (src.placeholders == null) {
            json.add("placeholders", EMPTY_OBJECT);
        } else {
            json.add("placeholders", Main.GSON.toJsonTree(src.placeholders));
        }
        return json;
    };
    private static final Map<String, Server> SERVERS = new HashMap<String, Server>();
    private final String name;
    private transient long lastInfoTime = 0L;
    private Map<String, Placeholder> placeholders;

    public Server(String name) {
        this.name = Objects.requireNonNull(name, "Server name is null");
    }

    public String getName() {
        return this.name;
    }

    public long getTimeSinceLastMessage() {
        return System.currentTimeMillis() - this.lastInfoTime;
    }

    public boolean isOnline() {
        int timeout = Main.getConfigurationManager().getApiConfiguration().getInt("server-offline-timeout", 6000);
        return this.getTimeSinceLastMessage() < (long)timeout;
    }

    public Collection<Placeholder> getPlaceholders() {
        return this.placeholders.values();
    }

    public boolean hasPlaceholder(String name) {
        return this.placeholders != null && this.placeholders.containsKey(name);
    }

    public Placeholder getPlaceholder(String name) {
        FileConfiguration configMisc = Main.getConfigurationManager().getMiscConfiguration();
        if (!this.isOnline()) {
            return new GlobalPlaceholder(name, configMisc.getString("placeholders.offline", "-"));
        }
        if (this.hasPlaceholder(name)) {
            return this.placeholders.get(name);
        }
        Main.getPlugin().getLogger().warning("Placeholder " + name + " was requested but not received from the server (" + this.getName() + ").");
        return new GlobalPlaceholder(name, configMisc.getString("placeholders.missing", "?"));
    }

    public int getOnlinePlayers() {
        return this.hasPlaceholder("online") ? Integer.parseInt(((GlobalPlaceholder)this.getPlaceholder("online")).getValue()) : 0;
    }

    public int getMaximumPlayers() {
        return this.hasPlaceholder("max") ? Integer.parseInt(((GlobalPlaceholder)this.getPlaceholder("max")).getValue()) : 0;
    }

    public void updatePlaceholders(Map<String, Placeholder> placeholders) {
        this.placeholders = placeholders;
        this.lastInfoTime = System.currentTimeMillis();
    }

    public static Map<String, Server> getServers() {
        return SERVERS;
    }

    public static Server getServer(String name) {
        Objects.requireNonNull(name, "Server name is null");
        if (SERVERS.containsKey(name)) {
            return SERVERS.get(name);
        }
        Server server = new Server(name);
        SERVERS.put(name, server);
        return server;
    }

    public static void clear() {
        SERVERS.clear();
    }
}

